# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_THAI} "(Use CD)"
LangString ReadOnly ${LANG_THAI} "(Read Only)"
LangString MainHeaderSubText ${LANG_THAI} "Please select username and password for the new account"
LangString MainLanguageLabel ${LANG_THAI} "Language:"
LangString MainUsernameLabel ${LANG_THAI} "Username:"
LangString MainPasswordLabel ${LANG_THAI} "Password:"
LangString MainInstallationSizeLabel ${LANG_THAI} "Installation Size (GB):"
LangString MainDistroLabel ${LANG_THAI} "Desktop Environment:"
LangString MainInstallationDriveLabel ${LANG_THAI} "Installation Drive ($freeSpace GB free):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_THAI} "Installation language."
LangString MainUsernameToolTip ${LANG_THAI} "Please select a username for the new account.$\r$\nIt must be lower case.$\r$\nIt must not contain spaces.$\r$\nIt must contain only standard letters and numbers.$\r$\nIt cannot start by a number."
LangString MainPasswordToolTip ${LANG_THAI} "Please select a password for the new account.$\r$\nIt must not contain spaces."
LangString MainInstallationSizeToolTip ${LANG_THAI} "How many GB do you want to allocate?$\r$\n4GB is the bare minimum$\r$\n8GB is comfortable"
LangString MainInstallationDriveToolTip ${LANG_THAI} "In which drive do you want to perform the installation?$\r$\nThis drive should have at least 5 GB free."
LangString Distro1ToolTip ${LANG_THAI} "Ubuntu is the default."
LangString Distro2ToolTip ${LANG_THAI} "Kubuntu uses the KDE3.5 desktop."
LangString Distro3ToolTip ${LANG_THAI} "Kubuntu-KDE4 uses the KDE4 desktop."
LangString Distro4ToolTip ${LANG_THAI} "Xubuntu is good for older systems."
LangString MainDistroToolTip ${LANG_THAI} "What graphical environment do you want to install?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_THAI} "Please enter a valid username"
LangString ErrorSpaceInUsername ${LANG_THAI} "Please do not use spaces in the username."
LangString ErrorUsernameUpperCase ${LANG_THAI} "Please use all lower cases in the username."
LangString ErrorUsernameFirstCharNotLetter ${LANG_THAI} "Your username must start with a letter."
LangString ErrorUsernameIllegalChars ${LANG_THAI} "Your username must contain only standard letters and numbers."
LangString ErrorReservedUsername ${LANG_THAI} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_THAI} "Please enter a valid password."
LangString ErrorPasswordMismatch ${LANG_THAI} "Passwords do not match."
LangString ErrorSpaceInPassword ${LANG_THAI} "Please do not use spaces in the password."
LangString ErrorNoFreeSpace ${LANG_THAI} "Not enough free space."
LangString ErrorNoKernel ${LANG_THAI} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_THAI} "Error while trying to execute bcdedit:"
LangString ErrorWubibcd ${LANG_THAI} "Error while trying to execute wubibcd:"
LangString ErrorCD2ISO ${LANG_THAI} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_THAI} "The download was interrupted with the error:"
LangString ErrorNoCD ${LANG_THAI} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_THAI} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_THAI} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_THAI} "You are about to install $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_THAI} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_THAI} "Please wait while the required files are retrieved and prepared"
LangString InstallHeaderUncompressWubifolder ${LANG_THAI} "Uncompressing wubi folder..."
LangString InstallHeaderCopyIso ${LANG_THAI} "Copying installation files..."
LangString InstallHeaderDownload ${LANG_THAI} "Retrieving installation files, resume supported"
LangString InstallHeaderBackupIso ${LANG_THAI} "Backing up installation files..."
LangString InstallHeaderWritePreseed ${LANG_THAI} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_THAI} "Setting up uninstaller..."
LangString InstallHeaderWriteBootLoader ${LANG_THAI} "Setting up bootloader..."
LangString InstallGenerateVirtualDisks ${LANG_THAI} "Creating virtual disks..."
LangString InstallCopyFiles ${LANG_THAI} "Copying installation files..."
LangString InstallCreateFolders ${LANG_THAI} "Creating folders..."
LangString InstallRetrieveIso ${LANG_THAI} "Retrieving installation files."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_THAI} "${AppName} is already installed"
LangString UninstallAsk ${LANG_THAI} "Do you want to uninstall it?"
LangString UninstallMessageField ${LANG_THAI} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_THAI} "Backup downloaded files (CD ISO file)."
LangString UninstallBackupHomeCheckBox ${LANG_THAI} "Backup personal documents (home.disk)."
LangString UninstallBackupLocationField ${LANG_THAI} "Backup location: $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_THAI} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_THAI} "You need to reboot to complete the installation."

# DOWNLOADER
LangString MetadlDownloading ${LANG_THAI} "Downloading installation files..."
LangString MetadlChecking ${LANG_THAI} "Checking installation files..."
LangString MetadlConnecting ${LANG_THAI} "Connecting to %s..."
LangString MetadlInitializing ${LANG_THAI} "Initializing..."
LangString MetadlChecksums ${LANG_THAI} "Calculating checksums..."
LangString MetadlRetrying1 ${LANG_THAI} "Retrying in %d seconds... (%d of %d)"
LangString MetadlRetrying2 ${LANG_THAI} "Retrying in %d seconds..."
LangString MetadlSecond ${LANG_THAI} "second"
LangString MetadlSeconds ${LANG_THAI} "seconds"
LangString MetadlProgress ${LANG_THAI} "%s (%d%%) of %s @ %s/s"
LangString MetadlRemaining ${LANG_THAI} " (%s remaining)"
LangString PleaseConnect ${LANG_THAI} "Please connect to the internet now."

# ACCESSIBILITY
LangString MobilityAids ${LANG_THAI} "Mobility Aids"
LangString VisibilityAids ${LANG_THAI} "Visibility Aids"
LangString AccessibilityButton ${LANG_THAI} "&Accessibility"
LangString AccessibilityText ${LANG_THAI} "Accessibility profile"
LangString AccessibilitySubText ${LANG_THAI} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_THAI} "None"
LangString VisibilityHighContrast ${LANG_THAI} "High Contrast"
LangString VisibilityMagnifier ${LANG_THAI} "Magnifier"
LangString VisibilityScreenReader ${LANG_THAI} "Screen Reader"
LangString VisibilityBraille ${LANG_THAI} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_THAI} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_THAI} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_THAI} "Install CD booter"
LangString CDBootText ${LANG_THAI} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_THAI} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_THAI} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_THAI} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_THAI} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_THAI} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
