/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Global
////////////////////////////////////////////////////////////////

var defaultURL = "";
const NEWSFOX = "NewsFox";
var collect = null;
var KMeleon = false;
var feedGroup = new Array();
var fdgpidx = new Array();
var feedidx = new Array();
var catgidx = new Array();
var openidx = new Array();
var dragLevel = 3;
var dragGrp = -1;
var numToCheck;
var firstLoad = true;
var loadIndex;

////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

var initNewsfox = false;
var autoRefreshTimer = null;
function startup()
{
  // This method was getting called twice, not sure why
  // so short circuit if method already invoked.
  if (initNewsfox) return;
	if (navigator.userAgent.indexOf('K-Meleon') > -1) KMeleon = true;
	options.startup();
	makeCss();
	collect = new EmptyCollection();
  initNewsfox = true;
  loadModels();
	backupOpml();
  setTimeout(loadAllFeeds,30);

	if( !KMeleon )
	{
		var newLivemarks = getNewLivemarks();
		if( newLivemarks.length )
		{
			var selected = new Array();
			var params = { ok:false, livemarks:newLivemarks, selected:selected, onlyNew:true };
			var win = window.openDialog("chrome://newsfox/content/livemarksDlg.xul",
				"newsfox-dialog","chrome,centerscreen,modal", params);

			if (params.ok)
			{
				updateLivemarks(newLivemarks, selected, true);
				refreshModel();    // need?  TODO
			}
		}
	}
	else
	{
		var mngLMbutton = document.getElementById("mngLMbutton");
		mngLMbutton.setAttribute("hidden", true);
	}

	frames["hrefContent"].location.href = "chrome://newsfox/locale/help/start.html";
	if (options.addUrl != "") addFeedUrl();
  if(options.checkOnStartup) 
    checkFeeds();

	if( options.autoRefresh )
		autoRefreshTimer = setTimeout(this.checkFeeds, options.autoRefreshInterval * 60 * 1000);

}

function saveModels()
{
  saveFeedModel();
  saveGroupModel();
  saveIndices();
}

function refreshModel()
{
  loadFeedModel();
  loadGroupModel();
  loadIndices();
  var tree = document.getElementById("newsfox.feedTree");
  tree.view = new FeedTreeModel();
}

function refreshModelSelect(index)
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var fRow = feedtree.treeBoxObject.getFirstVisibleRow();
  feedtree.view = new FeedTreeModel();
  feedtree.treeBoxObject.scrollToRow(fRow);
  feedtree.view.selection.select(index);
  feedtree.treeBoxObject.ensureRowIsVisible(index);
}

var clean = false;
function cleanup()
{
  if (!initNewsfox) return;
  if (clean) return;
	if( null != autoRefreshTimer )
		clearTimeout(autoRefreshTimer);
	options.cleanup();
  saveFeedModel();
  saveGroupModel();
  saveIndices();
  clean = true;
}

function openNewsfox(newTab)
{
	var tabbrowser = window.gBrowser;
  var tabs = tabbrowser.tabContainer.childNodes;
  var tab;
  for (var i = 0; i < tabs.length; ++i) {
    tab = tabs[i];
    var browser = tabbrowser.getBrowserForTab(tab);
		if("chrome://newsfox/content/newsfox.xul" == browser.contentDocument.location)
		{
			tabbrowser.selectedTab = tab;
			return;
		}
	}
	// if we got to this point, it means that no NewsFox in current window. Try to search other windows if any.

	var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                   .getService(Components.interfaces.nsIWindowMediator);
	var enumerator = wm.getEnumerator("navigator:browser");
	while(enumerator.hasMoreElements())
	{
	  var win = enumerator.getNext();
  	// |win| is [Object ChromeWindow] (just like |window|), do something with it
		tabbrowser = win.gBrowser;
	  tabs = tabbrowser.tabContainer.childNodes;
	  for (var i = 0; i < tabs.length; ++i) {
	    tab = tabs[i];
	    var browser = tabbrowser.getBrowserForTab(tab);
			if("chrome://newsfox/content/newsfox.xul" == browser.contentDocument.location)
			{
				// some problems with raising, so we close it to re-open after in current window
				browser.loadURI("about:blank", null, null); // if there is only one tab it'll not be removed. So, we change the browser location to save feeds
				tabbrowser.removeTab(tab);
			}
  	}
	}
	// Now we sure that no NewsFox is opened. Starting one.
	if (newTab) {
		getBrowser().addTab("chrome://newsfox/content/newsfox.xul")
	} else {
		getBrowser().loadURI("chrome://newsfox/content/newsfox.xul", null, null);
	}
}

function fixIndices()
// globals: feedGroup, fdgpidx, feedidx, catgidx, openidx
{
  for (var i=0; i<feedGroup.length; i++)
  {
    fdgpidx[i] = i;
    feedidx[i] = -1;
    catgidx[i] = 0;
    openidx[i] = feedGroup[i].expanded = false;
  }
  fdgpidx.length = feedidx.length = catgidx.length = openidx.length = feedGroup.length;
  var feedtree = document.getElementById("newsfox.feedTree");
  feedtree.view = new FeedTreeModel();
  saveIndices();

// check all feeds in group 0
  var modelSize = model.size();
  var isIn = new Array();
  for (i=0; i<modelSize; i++) isIn[i] = false;
  for (i=0; i<feedGroup[0].list.length; i++)
    isIn[feedGroup[0].list[i]] = true;
  for (i=0; i<modelSize; i++)
    if (!isIn[i]) feedGroup[0].list.push(i);

// check no higher numbered feeds
  for (i=0; i<feedGroup.length; i++)
    for (var j=0; j<feedGroup[i].list.length; j++)
      if (feedGroup[i].list[j] >= modelSize)
        feedGroup[i].list.splice(j,1);
}

function loadModels()
{
  var file = getProfileDir();
  file.append("master.xml");
  var hasFeeds = file.exists();
  var file = getProfileDir();
  file.append("master_index.xml");
  var hasGroups = file.exists();
  if (!hasGroups)
  {
    feedGroup[0] = new FeedGroup();
    feedGroup.length = 1;
    feedGroup[0].title = encodeString(document.getElementById("newsfox-string-bundle").getString('FEEDS'));
    feedGroup[0].expanded = false;
    fdgpidx[0] = 0;
    feedidx[0] = -1;
    catgidx[0] = 0;
    openidx[0] = false;
    if (hasFeeds)
    {
      loadFeedModel();
      for (var i=0; i<model.size(); i++)
        feedGroup[0].list[i] = i;
      feedGroup[0].list.length = model.size();
    }
    else
    {
      feedGroup[0].list.length = 0;
    }
    saveGroupModel();
    saveIndices();
  }
  if (hasFeeds) loadFeedModel();
  loadGroupModel();
  loadIndices();
  var feedtree = document.getElementById("newsfox.feedTree");
  feedtree.view = new FeedTreeModel();
  if (!hasGroups && hasFeeds) feedtree.view.toggleOpenState(0);
}

function loadAllFeeds()
{
  if (!firstLoad) return;
  firstLoad = false;
	loadIndex = model.size() - 1;
	if (loadIndex < 0) return;
	setTimeout(loadAFeed,30);
}

function loadAFeed()
{
	if (loadIndex == 0) return;
	loadFeed(model.get(loadIndex));
	loadIndex--;
	setTimeout(loadAFeed,30);
}

////////////////////////////////////////////////////////////////
// Commands
////////////////////////////////////////////////////////////////

/**
 * Check feeds for new items.
 */
function feedCheck(button)
{
// need to pass array of URLs in case feeds are deleted during check
  if (checkInProgress) return;
  checkInProgress = true;
  var feedtree = document.getElementById("newsfox.feedTree");
  var index = feedtree.currentIndex;
  var level = feedtree.view.getLevel(index);
  if (index == -1 || button) level = -1;

  var elem = document.getElementById("busyAnimation");
  elem.style.visibility = "visible";

  switch(level) 
  {
    case 0:  // check in group
      var curGrp = fdgpidx[index];
      for (var i=0; i<feedGroup[curGrp].list.length; i++)
				feedsToCheck.push(model.get(feedGroup[curGrp].list[i]).url);
      break;
		case 2:  // in category, check its feed
			while (feedtree.view.getLevel(index) != 1) index--;
			feedtree.view.toggleOpenState(index);
  		feedtree.view.selection.select(index);
    case 1:  // check feed
      feedsToCheck.push(model.get(feedidx[index]).url);
      break;
    case -1:  // none selected or button, do auto
      if( null != autoRefreshTimer )
        clearTimeout(autoRefreshTimer);
      for (var i=0; i<feedGroup[0].list.length; i++)
        if (model.get(feedGroup[0].list[i]).autoCheck)
          feedsToCheck.push(model.get(feedGroup[0].list[i]).url);
  }
  numToCheck = feedsToCheck.length;
	newItemsCount = 0;
  precheckFeed(feedsToCheck);
}

/**
 * Auto check feeds.
 */
function checkFeeds()
{
  feedCheck(true);
}

/**
 * Add a new group.
 */
function addGroup()
{
  var num = feedGroup.length;
  var grp = new FeedGroup();
  feedGroup.push(grp);
  var index = fdgpidx.length;
  fdgpidx.push(num);
  feedidx.push(-1);
  catgidx.push(0);
  openidx.push(false);
  saveIndices();
  saveGroupModel();
  var feedtree = document.getElementById("newsfox.feedTree");
  feedtree.treeBoxObject.rowCountChanged(index,1);
  showGroupOptions(index,true);
}

/**
 * Delete a group.
 */
function deleteGroup(confirm)
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var index = feedtree.currentIndex;
  if (feedtree.view.getLevel(index) != 0) return;
  var curGrp = fdgpidx[index];
  if (curGrp == 0) return;

  var stringsBundle = document.getElementById("newsfox-string-bundle");
  var confirmationMessage = stringsBundle.getString('confirmation.deleteGroup');
  confirmationMessage += "\n\n" + feedGroup[curGrp].title;
  if (!confirm || !options.confirmDelete || window.confirm(confirmationMessage))
  {
    if (feedGroup[curGrp].expanded) feedtree.view.toggleOpenState(index);
    feedGroup.splice(curGrp,1);
    for (var i=index+1;i < fdgpidx.length;i++)
      fdgpidx[i]--;
    fdgpidx.splice(index,1);
    feedidx.splice(index,1);
    catgidx.splice(index,1);
    openidx.splice(index,1);
    feedtree.treeBoxObject.rowCountChanged(index,-1);
    saveGroupModel();
    saveIndices();
		feedtree.view.selection.select(-1);
  }
}

/**
 * Add a new feed.
 */
function addFeed()
{
  var url = defaultURL;
  createNewFeed(model, url, false, true);
  var nFeed = model.size() - 1;
  var index = 0;
  while (nFeed != feedidx[index]) index++;
  showFeedOptions(index,true);
}

function addFeedUrl()
{
	defaultURL = options.addUrl;
	options.addUrl = "";
	options.save();
	addFeed();
	defaultURL = "";
}

function deleteRow()
{
  var feedtree = document.getElementById("newsfox.feedTree");
	var index = feedtree.currentIndex;
	var level = feedtree.view.getLevel(index);
  if (level == 1) deleteFeed(index,true);
	else if (level == 0) deleteGroup(true);
}

/**
 * Permanently delete a feed.
 */
function deleteFeed(index,confirm)
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var fRow = feedtree.treeBoxObject.getFirstVisibleRow();
  if (index == -1) index = feedtree.currentIndex;
  if (feedtree.view.getLevel(index) != 1) return;
  var nFeed = feedidx[index];
  var feed = model.get(nFeed);
  var stringsBundle = document.getElementById("newsfox-string-bundle");
  var confirmationMessage = stringsBundle.getString('confirmation.deleteFeed');
  confirmationMessage += "\n\n" + entityDecode(feed.getDisplayName());
  if (!confirm || !options.confirmDelete || window.confirm(confirmationMessage))
  {
    deleteFeedFromDisk(feed);
    for (var i=0; i<feedGroup.length; i++)
      for (var j=0; j<feedGroup[i].list.length; j++)
        if (feedGroup[i].list[j] >= nFeed)
            (feedGroup[i].list[j] == nFeed) ? feedGroup[i].list[j]=-2 : feedGroup[i].list[j]--;
    for (i=0; i<feedidx.length; i++)
      if (feedidx[i] >= nFeed)
        (feedidx[i] == nFeed) ? feedidx[i]=-2 : feedidx[i]--;
    for (var i=0; i<feedGroup.length; i++)
    {
      for (var j=feedGroup[i].list.length-1; j>=0; j--)
        if (feedGroup[i].list[j] == -2)
          feedGroup[i].list.splice(j,1);
      if (feedGroup[i].list.length == 0) openidx[getGroupRow(i)] = feedGroup[i].expanded = false;
    }
    for (i=feedidx.length-1; i>=0; i--)
      if (feedidx[i] == -2)
      {
        fdgpidx.splice(i,1);
        feedidx.splice(i,1);
        catgidx.splice(i,1);
        openidx.splice(i,1);
    		feedtree.treeBoxObject.rowCountChanged(i,-1);
      }

    model.remove(feed);
    saveModels();
    feedtree.treeBoxObject.scrollToRow(fRow);
		feedtree.view.selection.select(-1);
  }
}

/**
 * Delete articles.
 */
function deleteArticle()
{
  try
  {
    var tree = document.getElementById("newsfox.feedTree");
    var index = tree.currentIndex;
    var feed = model.get(feedidx[index]);

    var stringsBundle = document.getElementById("newsfox-string-bundle");
    var confirmationMessage = stringsBundle.getString('confirmation.deleteArticles');
    if (options.confirmDelete && !confirm(confirmationMessage))
      return;

    // Regular delete
    var arttree = document.getElementById("newsfox.articleTree");
		for (var i=0; i<collect.size(); i++)
			if (arttree.view.selection.isSelected(i))
				collect.getFeed(i).deleteByURL(collect.get(i).link);

		if (collect.type == 0 || collect.type == 3)  // group or search
		{
			var curGrp = feedGroup[collect.grpindex];
			for (i=0; i<curGrp.list.length; i++)
				saveFeed(model.get(curGrp.list[i]));
		}
		else                    // feed or category
    	saveFeed(feed);

    saveFeedModel();

    // Update unread count
    tree = document.getElementById("newsfox.feedTree");
    tree.treeBoxObject.invalidate();
    feedSelected();   // need new collection
  }
  catch (err)
  {
    var msg = "deleteArticle(): " + err;
    alert(msg);
  }
}

/**
 * Open articles.
 */
function openArticle()
{
  try
  {
    var arttree = document.getElementById("newsfox.articleTree");
		for (var i=0; i<collect.size(); i++)
			if (arttree.view.selection.isSelected(i))
				openNewTab(collect.get(i).link);
  }
  catch (err)
  {
    var msg = "openArticle(): " + err;
    alert(msg);
  }
}

function catchUp(doflag)
{
  var feedtree = document.getElementById("newsfox.feedTree");
  feedtree.view.selection.select(0);
  markFlaggedUnread(doflag,true);
}

function markFlaggedUnread(doflag,read)
{
  for(var i=0; i < collect.size(); i++)
  {
    var flagged = collect.isFlagged(i);
    collect.setRead(i, doflag ? !flagged : (read ? true : false));
    if (doflag) collect.setFlagged(i,0);
	}

  var feedtree = document.getElementById("newsfox.feedTree");
  feedtree.treeBoxObject.invalidate();
  var articleTree = document.getElementById("newsfox.articleTree");
  articleTree.treeBoxObject.invalidate();
}

function openUnread()
{
  var feedTree = document.getElementById("newsfox.feedTree");
  if( feedTree.currentIndex == -1) return;
  var article, read;
  for(var i=0; i < collect.size(); i++)
  {
    article = collect.get(i);
    read = collect.isRead(i);
    collect.setRead(i,true);
    if (!read) openNewTab(article.link);
  }
  feedTree.treeBoxObject.invalidate();
  var articleTree = document.getElementById("newsfox.articleTree");
  articleTree.treeBoxObject.invalidate();
}

/**
 * Show help.
 */
function help()
{
  frames["hrefContent"].location.href = "chrome://newsfox/locale/help/start.html";
	var contentDeck = document.getElementById("contentDeck");
	contentDeck.selectedIndex = 0;
}

/**
 * Goto to homepage of selected feed.
 */
function home()
{
  var tree = document.getElementById("newsfox.feedTree");
  var feed = model.get( feedidx[tree.currentIndex] );

  openNewTab(feed.homepage);
}

////////////////////////////////////////////////////////////////
// Options
////////////////////////////////////////////////////////////////

/**
 * Show global options.
 */
function showOptions()
{
  var params = { ok:false, style:options.globalStyle, checkOnStartup:options.checkOnStartup, autoRefresh:options.autoRefresh, autoRefreshInterval:options.autoRefreshInterval, notifyUponNew:options.notifyUponNew, confirmDelete:options.confirmDelete };
  var win = window.openDialog("chrome://newsfox/content/options.xul",
    "newsfox-dialog","chrome,centerscreen,modal", params);
	var oldAutoRefreshInterval = options.autoRefreshInterval;

  if (params.ok)
  {
    options.globalStyle = params.style;
    options.checkOnStartup = params.checkOnStartup;
		options.autoRefresh = params.autoRefresh;
		if( options.autoRefresh )
		{
			if( options.autoRefreshInterval != params.autoRefreshInterval )
			{
				if( null != autoRefreshTimer )
					clearTimeout(autoRefreshTimer);
				autoRefreshTimer = setTimeout(this.checkFeeds, params.autoRefreshInterval * 60 * 1000);
			}
		}
		else if( null != autoRefreshTimer )
			clearTimeout(autoRefreshTimer);
		options.autoRefreshInterval = params.autoRefreshInterval;
		options.notifyUponNew = params.notifyUponNew;
		options.confirmDelete = params.confirmDelete;
    options.save(false);
  }
}

/**
 * Show options dialog for current feed/group.
 */
function chooseOptions()
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var index = feedtree.currentIndex;
  if (index == -1) return;
  var level = feedtree.view.getLevel(index);
  if (level == 1) showFeedOptions(index,false);
	else showGroupOptions(index,false);
}

/**
 * Show options dialog for current group.
 */
function showGroupOptions(index,isNew)
{
	// following two lines due to a bug in FF that sometimes doesn't
	// hide context menu properly
  var feedMenu = document.getElementById("feedMenu");
	feedMenu.hidePopup();
  var feedtree = document.getElementById("newsfox.feedTree");
  var grp = fdgpidx[index];

  var expgrp = false;
  if (grp != 0 && feedGroup[grp].expanded)
  {
    feedtree.view.toggleOpenState(index);
    expgrp = true;
  }
  var exp0 = false;
  if (feedGroup[0].expanded)
  {
    feedtree.view.toggleOpenState(0);
    exp0 = true;
  }

  var feeds = new Array();
  for (var i=0; i<model.size(); i++)
    feeds.push(model.get(i));

  var titlelist = new Array();
  for (i=0; i<feedGroup.length; i++)
    titlelist.push(feedGroup[i].title);

  var lists = new Array();
  lists[0] = new Array();
  for (i=0; i<feedGroup[0].list.length; i++)
    lists[0].push(feedGroup[0].list[i]);
  lists[1] = new Array();
  for (i=0; i<feedGroup[grp].list.length; i++)
    lists[1].push(feedGroup[grp].list[i]);

  var params = { ok:false, grp:grp, newGrp:grp, feeds:feeds, titlelist:titlelist, lists:lists };
  var win = window.openDialog("chrome://newsfox/content/groupOptions.xul",
    "newsfox-dialog","chrome,centerscreen,modal", params);

  if (params.ok)
  {
    feedGroup[grp].title = encodeString(params.titlelist[grp]);
    var feedslist = params.lists[0];
    for (i=0; i<feedslist.length; i++)
      feedGroup[0].list[i] = feedslist[i];
    feedGroup[0].list.length = feedslist.length;
    var grplist = params.lists[1];
    for (i=0; i<grplist.length; i++)
      feedGroup[grp].list[i] = grplist[i];
    feedGroup[grp].list.length = grplist.length;
    mvGrp(grp,params.newGrp);
		grp = (params.newGrp >= grp) ? params.newGrp-1 : params.newGrp;
    if (feedGroup[grp].list.length == 0) expgrp = false;
    saveIndices();
    saveGroupModel();
    loadGroupModel();
  }
  else    // !params.ok
  {
    if (isNew)
    {
      refreshModelSelect(index);
      deleteGroup(false);
    }
  }
  if (exp0) feedtree.view.toggleOpenState(0);
  index = getGroupRow(grp);
  if (expgrp) feedtree.view.toggleOpenState(index);
  refreshModelSelect(index);
}

/**
 * Show options dialog for current feed.
 */
function showFeedOptions(index,isNew)
{
  var checkFeed = false;
  var curGrp = fdgpidx[index];
  var nFeed = feedidx[index];
  var feed = model.get(nFeed);
  var namearray = new Array();
  var membarray = new Array();
  var tmp, j;
  for (var i=0; i<feedGroup.length; i++)
  {
    namearray.push(feedGroup[i].title);
    tmp = 0;
    for (j=0; j<feedGroup[i].list.length; j++)
      if (feedGroup[i].list[j] == nFeed) tmp = 1;
    membarray.push(tmp);
  }
  var groupstr = namearray.join();
  var groupmemb = membarray.join();

  var params = { ok:false, name:entityDecode(feed.getDisplayName()), iconsrc:feed.icon.src, homepage:feed.homepage, url:feed.url, style:feed.style, deleteOld:feed.deleteOld, dontDeleteUnread:feed.dontDeleteUnread, autoCheck:feed.autoCheck, groupstr:groupstr, groupmemb:groupmemb, isNew:isNew, checkFeed:checkFeed, uid:feed.uid, model:model };
  var win = window.openDialog("chrome://newsfox/content/feedOptions.xul",
    "newsfox-dialog","chrome,centerscreen,modal", params);

  if (params.ok)
  {
    var newmembarray = params.groupmemb.split(",");
    for (i=0; i<membarray.length; i++)
    {
      var diff = newmembarray[i] - membarray[i];
      if (diff == 1)  // adding
      {
        feedGroup[i].list.push(nFeed);
        if (feedGroup[i].expanded)
        {
          var top = getGroupRow(i+1);
          fdgpidx.splice(top,0,i);
          feedidx.splice(top,0,nFeed);
          catgidx.splice(top,0,0);
          openidx.splice(top,0,false);
        }
      }
      else if (diff == -1)  // deleting
      {
        for (var j=feedGroup[i].list.length-1; j>=0; j--)
          if (feedGroup[i].list[j] == nFeed)
            feedGroup[i].list.splice(j,1);
        if (feedGroup[i].list.length == 0) openidx[getGroupRow(i)] = feedGroup[i].expanded = false;
        var grprow = getGroupRow(i);
        var top = getGroupRow(i+1);
        for (j=top-1; j>=grprow; j--)
          if (feedidx[j] == nFeed)
          {
            fdgpidx.splice(j,1);
            feedidx.splice(j,1);
            catgidx.splice(j,1);
            openidx.splice(j,1);
          }
      }
    }

    feed.url = params.url.trim();
    feed.style = params.style;
    feed.deleteOld = params.deleteOld;
    feed.dontDeleteUnread = params.dontDeleteUnread;
    feed.autoCheck = params.autoCheck;
    if (isNew)
    {
      var uid = model.makeUniqueUid(feed.url);
      feed.uid = uid;
			deleteFeedFromDisk(feed);
      feed.defaultName = uid;
			feed.homepage = null;   // TODO feed.homepage gets set via downloadicon?
    }
    else
    {
      var val = params.name.trim();
      if (val == feed.defaultName) feed.customName = ""
      else feed.customName = encodeString(val);
      if (params.iconsrc == "")
        feed.icon.src = iconOk;
      else
        feed.icon.src = params.iconsrc.trim();
      feed.homepage = params.homepage.trim();
      downloadIcon(feed);
    }
    saveModels();
    index = getGroupRow(curGrp);    // index may have changed, recompute
    while (feedidx[index] != nFeed && index < fdgpidx.length) index++;
    if (feedidx[index] != nFeed)
    {
      index=0;
      while (feedidx[index] != nFeed  && index < fdgpidx.length) index++;
      if (feedidx[index] != nFeed)    // can't happen, feed still exists
      { 
        refreshModelSelect(0);
        return;
      }
    }
    refreshModelSelect(index);
    if (params.checkFeed) feedCheck(false);
  }
  else   //  !params.ok
  {
    if (isNew)
    {
//      refreshModelSelect(index);
      deleteFeed(index,false);
    }
  }
}

/**
 * Troubleshoot feed errors.
 */
function troubleshoot()
{
  var tree = document.getElementById("newsfox.feedTree");
  var nFeed = feedidx[tree.currentIndex];
  if (nFeed < 0) return;
  var feed = model.get(nFeed);

	resetIframe();
  var iframe = document.getElementById("buildContent");
  var doc = iframe.contentDocument;

  var summary = getErrorSummary(feed.error);
  var remedies = getErrorRemedies(feed.error);

  var b = doc.createElement("b");
  b.appendChild(doc.createTextNode(summary));

  var p = doc.createElement("p");
  p.innerHTML = remedies;

  doc.body.appendChild(b);
  doc.body.appendChild(doc.createElement("hr"));
  doc.body.appendChild(p);

	var contentDeck = document.getElementById("contentDeck");
	contentDeck.selectedIndex = 1;
	frames["hrefContent"].location.href = "about:blank";
}

////////////////////////////////////////////////////////////////
// Selection
////////////////////////////////////////////////////////////////

/**
 * Feed selected.
 */
function feedSelected()
{
  var tree = document.getElementById("newsfox.feedTree");
  var index = tree.currentIndex;
  var arttree = document.getElementById("newsfox.articleTree");
  if (index == -1)
	{
		collect = new EmptyCollection();
		arttree.view = null;
		return;
	}
  var nFeed = feedidx[index];
  if (nFeed < 0)  // group
	{
		loadingTooltip(true);
		var grpindex = fdgpidx[index];
		var grp = feedGroup[grpindex];
		for (var i=0; i<grp.list.length; i++)
		{
			loadFeed(model.get(grp.list[i]));
			setPmeter((100*i)/grp.list.length);
		}
		collect = new GroupCollection(grpindex);
		setPmeter(0);
		loadingTooltip(false);
	}
	else
	{
  	var feed = model.get(nFeed);
		downloadIcon(feed);
		loadFeed(feed);
		feed.flags.length = feed.size();
//RPdebug if (feed.flags.length != feed.size()) 
//RPdebug  alert("feed flags length " + feed.flags.length + "     feed.size " + feed.size());

		collect = new NormalCollection(nFeed, catgidx[index],true);
	}
  
  arttree.view = null;  
  arttree.view = new ArticleTreeModel();

//	troubleshoot();
}

/**
 * Article selected.
 */
function articleSelected()
{
  var tree = document.getElementById("newsfox.articleTree");
  var index = tree.currentIndex;
	if (index == -1) return;
  var art = collect.get(index);
  var read = collect.isRead(index);

  if (!read)
  {
    collect.setRead(index, true);
    tree.treeBoxObject.invalidateRow(index);
    var tree = document.getElementById("newsfox.feedTree");
    tree.treeBoxObject.invalidate();
  }

  // Display body in content
	var contentDeck = document.getElementById("contentDeck");
  var style = collect.getFeed(index).getStyle();
  if (style == 2)
  {
    // Display as webpage
    frames["hrefContent"].location.href = art.link;
		contentDeck.selectedIndex = 0;
  }
  else
  {
		// display using innerHTML to resolve security issues pointed out by Wladimir Palant
		resetIframe();
		getTextView(art);
		contentDeck.selectedIndex = 1;
		frames["hrefContent"].location.href = "about:blank";
  }
}

function articleTreeMClicked()
{
	var tree = document.getElementById("newsfox.articleTree");
	var index = tree.currentIndex;
	if (index == -1) return;  // in header
	var article = collect.get(index);
	openNewTab(article.link);
}

function articleTreeDblClicked()
{
	this.articleTreeMClicked();
}

/**
 * Select the next unread article.
 */
function selectNextUnreadArticle()
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var arttree = document.getElementById("newsfox.articleTree");
  var row = feedtree.currentIndex;
  if (row < 0) return;
  var curGrp = fdgpidx[row];
	var artIndex = arttree.currentIndex;
	if (artIndex < 0) artIndex = 0;
  if (collect.type != 1)  // group or category
	{
		for (var j = artIndex; j < collect.size(); j++)
			if (!collect.isRead(j))
			{
				arttree.view.selection.select(j);
	      arttree.treeBoxObject.ensureRowIsVisible(j);
	      return;
			}
	}
	else   // feed
	{
	// current row
	  var feed = model.get(feedidx[row]);
	  feedtree.view.selection.select(row);
	  feedtree.treeBoxObject.ensureRowIsVisible(row);
	  for (var j = artIndex; j < feed.size(); j++)
	    if (!feed.isRead(j))
	    {
	      arttree.view.selection.select(j);
	      arttree.treeBoxObject.ensureRowIsVisible(j);
	      return;
	    }
	// rest of folder
	  while (++row < fdgpidx.length && fdgpidx[row] == curGrp)
	  {
	    feed = model.get(feedidx[row]);
	    feedtree.view.selection.select(row);
	    feedtree.treeBoxObject.ensureRowIsVisible(row);
	    for (var j = 0; j < feed.size(); j++)
	      if (!feed.isRead(j))
	      {
	        arttree.view.selection.select(j);
	        arttree.treeBoxObject.ensureRowIsVisible(j);
	        return;
	      }
	  }
	}
  var stringsBundle = document.getElementById("newsfox-string-bundle");
  var noNextUnread = stringsBundle.getString('noNextUnread');
  alert(noNextUnread);
}

/**
 * Select the previous unread article.
 */
function selectPrevUnreadArticle()
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var arttree = document.getElementById("newsfox.articleTree");
  var row = feedtree.currentIndex;
  if (row < 0) return;
  var curGrp = fdgpidx[row];
  var artIndex = arttree.currentIndex;
  if (artIndex < 0)
  {
    artIndex = collect.size()-1;
    if (artIndex < 0) artIndex = 0;
  }
  if (collect.type != 1)  // group or category
	{
		for (var j = artIndex; j >= 0; j--)
			if (!collect.isRead(j))
			{
				arttree.view.selection.select(j);
	      arttree.treeBoxObject.ensureRowIsVisible(j);
	      return;
			}
	}
	else   // feed
	{
	// current row
	  var feed = model.get(feedidx[row]);
	  feedtree.view.selection.select(row);
	  feedtree.treeBoxObject.ensureRowIsVisible(row);
	  for (var j = artIndex; j >= 0; j--)
	    if (!feed.isRead(j))
	    {
	      arttree.view.selection.select(j);
	      arttree.treeBoxObject.ensureRowIsVisible(j);
	      return;
	    }
	// rest of folder
	  while (fdgpidx[--row] == curGrp && feedidx[row] > -1)
	  {
	    var feed = model.get(feedidx[row]);
	    feedtree.view.selection.select(row);
	    feedtree.treeBoxObject.ensureRowIsVisible(row);
	    for (var j = feed.size()-1; j >= 0; j--)
	      if (!feed.isRead(j))
	      {
	        arttree.view.selection.select(j);
	        arttree.treeBoxObject.ensureRowIsVisible(j);
	        return;
	      }
	  }
	}
  var stringsBundle = document.getElementById("newsfox-string-bundle");
  var noPrevUnread = stringsBundle.getString('noPrevUnread');
  alert(noPrevUnread);
}

////////////////////////////////////////////////////////////////
// Event Handlers
////////////////////////////////////////////////////////////////

/**
 * Route events.
 */
function handleEvent(e) 
{
  if (e.keyCode == 0) handleMouseEvent(e);
  handleKeyEvent(e);
}

/**
 * Handle mouse events.
 */
function handleMouseEvent(e) 
{
}

/**
 * Handle keyboard events.
 */
function handleKeyEvent(e)
{
	var focus = 0;
	var focusId = document.commandDispatcher.focusedElement.id;
	if (focusId == "newsfox.feedTree") focus = 1;
	else if (focusId == "newsfox.articleTree") focus = 2;
	else return;

  switch(e.keyCode) 
  {
    case 40:  // down-arrow
      if (e.altKey) 
      {
        e.stopPropagation();
        e.preventDefault();
        selectNextUnreadArticle(); 
      }
      else if (e.ctrlKey)
				if (focus == 1) moveIt(false);
      break;

    case 38:   // up-arrow
      if (e.altKey) 
      {
        e.stopPropagation();
        e.preventDefault();
        selectPrevUnreadArticle(); 
      }
      else if (e.ctrlKey)
				if (focus == 1) moveIt(true);
      break;

    case 46: // delete
      if (focus == 2) deleteArticle();
      else if (focus == 1) deleteRow();
      break;
  }
}

////////////////////////////////////////////////////////////////
// FeedTreeModel
////////////////////////////////////////////////////////////////

function dragIt(evt) {
  var tree = evt.target.parentNode;
  if (tree.id != "newsfox.feedTree") return;
  var row = {}, col = {}, type = {};
  tree.treeBoxObject.getCellAt(evt.clientX, evt.clientY, row, col, type);
  dragLevel = tree.view.getLevel(row.value);
  dragGrp = fdgpidx[row.value]; 
  if (dragLevel <= 1) nsDragAndDrop.startDrag(evt,feedtreeObserver);
}

var feedtreeObserver = {
 
  onDragStart: function (evt,transferData,action)
  { 
    var row = {}, col = {}, type = {};
    evt.target.parentNode.treeBoxObject.getCellAt(evt.clientX, evt.clientY, row, col, type); 
    transferData.data=new TransferData(); 
    transferData.data.addDataForFlavour("feedtreerow",feedidx[row.value]); 
  },

  getSupportedFlavours : function ()
  { 
		var flavours = new FlavourSet(); 
		flavours.appendFlavour("feedtreerow"); 
		return flavours; 
  }, 

  onDragOver: function (evt,flavour,session){}, 

  onDrop: function (evt,dropdata,session){} 
};

function FeedTreeModel() 
{
  // 3/25/05 - Temp disable flag/trash folder
  //this.rowCount = model.size() + 2;
  // AG: added category. Most subcode is reworked
  // 11 Jan 07 RP: remove flag/trash, add groups, code reworked

  this.rowCount = fdgpidx.length;
  this.isTopLevelElement = function(row){ return (this.getLevel(row) == 0); }
  this.getCellText = function(row,col)
  {
    var level = this.getLevel(row);
    var text, unread;
    if (level == 0)
    {
      var curfeedGroup = feedGroup[fdgpidx[row]];
      text = entityDecode(curfeedGroup.title);
      unread = curfeedGroup.getUnread();
			if (row == 0) newTitle(unread);
    }
    else
    {
      var feed = model.get(feedidx[row]);
      var nCategory = catgidx[row]; 
      text = "";
      unread = feed.getUnread(nCategory);
      if( nCategory )
      {
        var categories = feed.getCategories();
        text = entityDecode(categories[nCategory-1]);
      }
      else
        text =  entityDecode(feed.getDisplayName());
    }
    if (unread > 0) text += " (" + unread + ")";
    return text; 
  }
  this.setTree = function(treebox){ this.treebox = treebox; }
  this.isContainer = function(row){ return (this.getLevel(row) < 2); }
  this.isContainerEmpty = function(row)
  {
    var level = this.getLevel(row);
    var feed = model.get(feedidx[row]);
    if (level == 0 && feedGroup[fdgpidx[row]].list.length) return false;
    if (level == 1 && feed.loaded && feed.getCategories().length) return false;
    return true;
  }
  this.isContainerOpen = function(row){ return openidx[row]; }
  this.hasNextSibling = function(row, index)
  {
    if (index+1 > fdgpidx.length-1) return false;
    var level = this.getLevel(row);
    if (level == 0) return (fdgpidx[fdgpidx.length-1] != fdgpidx[row]);
    else if (level == 1) return (fdgpidx[index+1] == fdgpidx[row]);
    else return ((fdgpidx[index+1] == fdgpidx[row]) && (feedidx[index+1] == feedidx[row]));
  }
  this.getParentIndex = function(row)
  {
    var index = row;
    var level = this.getLevel(row);
    if (level == 0) index = -2;
    else if (level == 1)
      while (fdgpidx[index] == fdgpidx[row]) index--;
    else
      while (feedidx[index] == feedidx[row]) index--;
    return ++index; 
  }
  this.isSeparator = function(row){ return false; }
  this.isEditable = function(row,col){ return false; }
  this.isSorted = function(row){ return false; }
  this.getLevel = function(row)
  {
    var level = 0;
    if (catgidx[row] > 0) level = 2;
    else if (feedidx[row] > -1) level = 1;
    return level; 
  }
  this.getImageSrc = function(row,col) 
  {
    var retval = null;
    var level = this.getLevel(row);
    if (level == 0)
      {
        if (this.isContainerOpen(row)) 
          retval = folderOpen;
				else
          retval = folderClosed;
      }
    else if (level == 1)
      {
        var feed = model.get(feedidx[row]);
        var nofeederror = (feed.error == ERROR_OK);
        retval = nofeederror ? feed.icon.src : iconErr;
      }
    return retval;
  }
  this.getRowProperties = function(row,props) {}
  this.getCellProperties = function(row,col,props) 
  {
		if (catgidx[row] == 0)
		{
			var aserv = Components.classes["@mozilla.org/atom-service;1"].
			getService(Components.interfaces.nsIAtomService);
			props.AppendElement(aserv.getAtom("faviconcol"));
		}
    var hasUnread = false;
    var nFeed = feedidx[row];
    if (nFeed == -1 && feedGroup[fdgpidx[row]].getUnread() > 0)
      hasUnread = true;
    if (nFeed > -1 && model.get(nFeed).getUnread(catgidx[row]) > 0)
      hasUnread = true;
    if (hasUnread)
    {
      var aserv = Components.classes["@mozilla.org/atom-service;1"].
        getService(Components.interfaces.nsIAtomService);
      props.AppendElement(aserv.getAtom("unread"));
    }
  }
  this.getColumnProperties = function(colid,col,props){}
  this.toggleOpenState = function(row)
  {
    if (this.isContainerEmpty(row)) return;
    var feedtree = document.getElementById("newsfox.feedTree");
    var fRow = feedtree.treeBoxObject.getFirstVisibleRow();
    var level = this.getLevel(row);
    if (level == 0)
    {
      var curGrp = fdgpidx[row];
      var grp = feedGroup[curGrp];
      if (grp.expanded)
      {
        var num = 0;
        while (fdgpidx[row+num] == curGrp) num++;
        num--;
        fdgpidx.splice(row+1,num);
        feedidx.splice(row+1,num);
        catgidx.splice(row+1,num);
        openidx.splice(row+1,num);
    		feedtree.treeBoxObject.rowCountChanged(row+1,-num);
      }
      else
      {
        for (var i=1; i <= grp.list.length; i++)
        {
          fdgpidx.splice(row+i,0,curGrp);
          feedidx.splice(row+i,0,grp.list[i-1]);
          catgidx.splice(row+i,0,0);
          openidx.splice(row+i,0,false);
        }
    		feedtree.treeBoxObject.rowCountChanged(row+1,grp.list.length);
      }
      grp.expanded = !grp.expanded;
      openidx[row] = !openidx[row];
    }
    else if (level == 1)
    {
      var curFeed = feedidx[row];
      var feed = model.get(curFeed);
      if (openidx[row])
      {
        var num = 0;
        while (feedidx[row+num] == curFeed) num++;  // can't use categories.length since # categories may change
        num--;
        fdgpidx.splice(row+1,num);
        feedidx.splice(row+1,num);
        catgidx.splice(row+1,num);
        openidx.splice(row+1,num);
    		feedtree.treeBoxObject.rowCountChanged(row+1,-num);
      }
      else
      {
        for (var i=1; i <= feed.getCategories().length; i++)
        {
          fdgpidx.splice(row+i,0,fdgpidx[row]);
          feedidx.splice(row+i,0,feedidx[row]);
          catgidx.splice(row+i,0,i);
          openidx.splice(row+i,0,false);
        }
    		feedtree.treeBoxObject.rowCountChanged(row+1,feed.getCategories().length);
      }
      openidx[row] = !openidx[row];
    }
    else return;
    saveModels();
    feedtree.treeBoxObject.scrollToRow(fRow);
  }
  this.canDrop = function(row,orientation) 
  {
//    if (orientation == 0) return false;
    switch (this.getLevel(row))
    {
      case 0:
	return (dragLevel == 0) ? true : false;
      case 1:
	return (dragLevel == 1 && dragGrp == fdgpidx[row]) ? true : false;
      case 2:
      default:
	return false;
    }
  }
  this.drop = function(row,orientation)
  {
    var flavourSet = feedtreeObserver.getSupportedFlavours();
    var transferData = nsTransferable.get(flavourSet, nsDragAndDrop.getDragData, true);
    var dropdata = transferData.first.first;
    var oldFeed = dropdata.data;
    var newGrp = fdgpidx[row] + (orientation == 1);
    var newFeed = feedidx[row];
    if (orientation == 1)
    {
      var i = row;
      while (feedidx[i] == newFeed) i++;
      if (fdgpidx[i] == dragGrp) newFeed = feedidx[i]
      else newFeed = -2;
    }
    if (dragLevel == 0) mvGrp(dragGrp,newGrp);
    else   // dragLevel == 1
      mvFeed(dragGrp,oldFeed,newFeed);
    dragLevel = 3;
    dragGrp = -1;
  }
}

////////////////////////////////////////////////////////////////
// ArticleTreeModel
////////////////////////////////////////////////////////////////

function ArticleTreeModel() 
{
  var flagIcon = "chrome://newsfox/skin/images/flag.png";
  var readIcon = "chrome://newsfox/skin/images/read.png";
  var unreadIcon = "chrome://newsfox/skin/images/unread.png";

	removeHeaderArrows();

  this.rowCount = collect.size();
  this.getCellText = function(row,col)
  {
    // Try to handle both Firefox 1.0 and 1.1
    var colId = (col.id) ? col.id : col;
    switch (colId)
    {
      case "title": return entityDecode(collect.get(row).title);
      case "date":  return collect.get(row).date.toLocaleString();
      default: return "debug-" + col;
    }
  }
  this.setTree = function(treebox){ this.treebox = treebox; }
  this.isContainer = function(row){ return false; }
  this.isSeparator = function(row){ return false; }
  this.isSorted = function(row){ return false; }
  this.getLevel = function(row){ return 0; }
  this.getImageSrc = function(row,col)
  { 
    var read = collect.isRead(row);
    var flag = collect.isFlagged(row);

    // Try to handle both Firefox 1.0 and 1.1
    var colId = (col.id) ? col.id : col;
    switch (colId)
    {
      case "read": return read ? readIcon : unreadIcon;
      case "flag": return flag ? flagIcon : readIcon;
			case "title": return (collect.type == 0) ? collect.getFeed(row).icon.src : null;
      default: return null;
    }
  }
  this.getRowProperties = function(row,props) {}
  this.getCellProperties = function(row,col,props) 
  {
    // Try to handle both Firefox 1.0 and 1.1
    var colId = (col.id) ? col.id : col;
		if (colId == "title" && collect.type == 0)
		{
			var aserv = Components.classes["@mozilla.org/atom-service;1"].
			getService(Components.interfaces.nsIAtomService);
			props.AppendElement(aserv.getAtom("faviconcol"));
		}
    if (!collect.isRead(row))
    {
      var aserv = Components.classes["@mozilla.org/atom-service;1"].
        getService(Components.interfaces.nsIAtomService);
      props.AppendElement(aserv.getAtom("unread"));
    }
  }
  this.getColumnProperties = function(colid,col,props) {}
  this.cycleHeader = function(col,elem)
  {
    // Try to handle both Firefox 1.0 and 1.1
    var colId = (col.id) ? col.id : col;

		var colObj = document.getElementById(colId);
		var direction = colObj.getAttribute("sortDirection");
		removeHeaderArrows();
		var newDir;
		switch (colId)
		{
			case "flag":
			case "title":
				newDir = "ascending";
				if (direction == "ascending") newDir = "descending";
				break;
			case "read":
			case "date":
				newDir = "descending";
				if (direction == "descending") newDir = "ascending";	
		}
    var arttree = document.getElementById("newsfox.articleTree");
		arttree.blur();
		arttree.view.selection.select(-1);
		collect.artSort(colId,newDir);
		if (collect.type == 1)  // feed, not group or category
		{
			saveFeed(collect.feed); 	// feed(s) not changed by resorting
			saveFeedModel();					// group or category
		}
		colObj.setAttribute("sortDirection", newDir);
  }
  this.cycleCell = function(row,col)
  {
    // Try to handle both Firefox 1.0 and 1.1
    var colId = (col.id) ? col.id : col;

    if (colId == "read") 
    {
      var read = collect.isRead(row);
      collect.setRead(row, !read);
      var tree = document.getElementById("newsfox.feedTree");
      tree.treeBoxObject.invalidate();
    }
    else if (colId == "flag")
    {
      var flag = collect.isFlagged(row);
      collect.setFlagged(row, !flag);
    }
  }
}

////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////

function openNewTab(url)
{
	if(!KMeleon)
	{
		const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
		const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
		const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
		var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
		var browser = browserWindow.getBrowser();
		var tab = browser.addTab(url);
	}
	else
	{
		window.open(url);
		window.focus();
	}
//  ctrl-alt-tab to open in background on K-M
}

function manageLivemarks()
{
	var allLivemarks = liveBookmarks.getAllUnique();
	var selected = new Array();
	for( var i=0; i < model.sizeTotal(); i++)
	{
		var feed = model.get(i);
		if( !feed.exclude )
			selected.push(feed.url);
	}
	var params = { ok:false, livemarks:allLivemarks, selected:selected };
  var win = window.openDialog("chrome://newsfox/content/livemarksDlg.xul",
    "newsfox-dialog","chrome,centerscreen,modal", params);

	if (params.ok)
	{
		updateLivemarks(allLivemarks, selected, false);
		refreshModel();
	}
}

function updateLivemarks(livemarks, selected, bNew)
{
  for( var i=0; i < livemarks.length; i++ )
  {
    var feed = model.getFeedByURL(livemarks[i].URL);
    var isExcluded = true;
    for( var k = 0; k < selected.length; k++ )
      if( selected[k] == livemarks[i].URL )
      {
        isExcluded = false;
        break;
      }
    if( bNew || !feed)  // new feed
    {
      feed = createNewFeed(model,livemarks[i].URL,isExcluded,true);
      feed.setDefaultName(livemarks[i].title);
    }
    else  // current feed
    {
      if (feed.exclude != isExcluded)
      {
        if (feed.exclude)   // make included
        {
          model.remove(feed);
          var inclfeed = createNewFeed(model,feed.url,false,true);
          inclfeed.setDefaultName(livemarks[i].title);
        }
        else                // make excluded
        {
          var feedtree = document.getElementById("newsfox.feedTree");
          if (!feedGroup[0].expanded) feedtree.view.toggleOpenState(0);
          var index = -1;
          for (var j=1; j<=model.size(); j++)
            if (feed.url == model.get(feedidx[j]).url) index = j;
          if (index == -1) return;
          deleteFeed(index,false);
          var exclfeed = createNewFeed(model,feed.url,true,true);
          exclfeed.setDefaultName(livemarks[i].title);
        }
      }
    }
  saveModels();
  }
}

function onOptMenuShowing(menu)
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var index = feedtree.currentIndex;
  var level = feedtree.view.getLevel(index);
  if (index == -1) level = -1;

  var children = menu.childNodes;
  for (var i = 0; i < children.length; i++)
  {
    var id = children[i].getAttribute("id");
    switch (id)
    {
      case "tool.group":
	if (level == 0) children[i].setAttribute("disabled",false)
	else children[i].setAttribute("disabled",true);
	break;
      case "tool.feed":
	if (level == 1) children[i].setAttribute("disabled",false)
	else children[i].setAttribute("disabled",true);
	break;
    }
  }
  return true;
}

function onFeedMenuShowing(menu)
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var index = feedtree.currentIndex;
	if (index == -1) return false;
  var level = feedtree.view.getLevel(index);

  var children = menu.childNodes;
  for (var i = 0; i < children.length; i++)
  {
    var id = children[i].getAttribute("id");
    switch (id)
    {
      case "home":
	if (level == 0 || model.get(feedidx[index]).homepage == "") children[i].setAttribute("disabled",true)
	else children[i].setAttribute("disabled",false);
	break;
      case "checkFeed":
      case "props":
	if (level <= 1) children[i].setAttribute("disabled",false)
	else children[i].setAttribute("disabled",true);
	break;
    }
  }
  return true;
}

function mvGrp(oldgrp, newgrp)
{
  if (oldgrp == newgrp || oldgrp+1 == newgrp || oldgrp == 0 || newgrp == 0) return;
  var up = 1*(newgrp > oldgrp);
  var down = 1 - up;
  var newrow = getGroupRow(newgrp);
  var oldrow = getGroupRow(oldgrp);
  var i = oldrow;
  while (i < fdgpidx.length && fdgpidx[i] == oldgrp) i++;
  var num = i - oldrow;
  for (i=0; i<num; i++)
  {
    fdgpidx.splice(newrow+i*down,0,fdgpidx[oldrow+i*down]);
    fdgpidx.splice(oldrow+(i+1)*down,1);
    feedidx.splice(newrow+i*down,0,feedidx[oldrow+i*down]);
    feedidx.splice(oldrow+(i+1)*down,1);
    catgidx.splice(newrow+i*down,0,catgidx[oldrow+i*down]);
    catgidx.splice(oldrow+(i+1)*down,1);
    openidx.splice(newrow+i*down,0,openidx[oldrow+i*down]);
    openidx.splice(oldrow+(i+1)*down,1);
  }
  var tmpGrp = feedGroup[oldgrp];
  feedGroup.splice(oldgrp,1);
  feedGroup.splice(newgrp-up,0,tmpGrp);
  grpChg(oldgrp,-2);
  if (newgrp > oldgrp)
  {
    newgrp--;
    for (var i=0; i<(newgrp-oldgrp); i++)
      grpChg(oldgrp+i+1,oldgrp+i);
  }
  else
    for (var i=0; i<(oldgrp-newgrp); i++)
      grpChg(oldgrp-i-1,oldgrp-i);
  grpChg(-2,newgrp);
  saveGroupModel();
  saveIndices();
  refreshModelSelect(newrow - up*num);
}

function grpChg(oldgrp,newgrp)
{
  for (var i=0; i<fdgpidx.length; i++)
    if (fdgpidx[i] == oldgrp)
      fdgpidx[i] = newgrp;
}

function getGroupRow(grp)
{
  var i = fdgpidx.length - 1;
  while (i >= 0 && fdgpidx[i] >= grp) i--;
  return ++i;
}

function getFeedRow(grp,nFeed)
{
  var i = getGroupRow(grp);
  while (i < fdgpidx.length && fdgpidx[i] == grp && feedidx[i] != nFeed) i++;
  return i;  // returns row after last feed if not in group
}

function moveIt(movingUp)
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var index = feedtree.currentIndex;
  var curGrp = fdgpidx[index];
  var curFeed = feedidx[index];
  if (catgidx[index] != 0) return;  // on category
  if (curFeed == -1)                // on group
  {
    if (movingUp && curGrp <= 1) return;
    if (!movingUp && curGrp == feedGroup.length-1) return;
    var newGrp = curGrp + 2;
    if (movingUp) newGrp -= 3;
    mvGrp(curGrp,newGrp);
  }
  else                             // on feed
  {
    var curPos = -1;
    for (var i=0; i<feedGroup[curGrp].list.length; i++)
      if (feedGroup[curGrp].list[i] == curFeed) curPos = i;
    if (movingUp && curPos == 0) return;
    if (!movingUp && curPos == feedGroup[curGrp].list.length-1) return;
    var newFeed;
    if (movingUp) newFeed = feedGroup[curGrp].list[curPos-1]
    else if (curPos+2 == feedGroup[curGrp].list.length) newFeed = -2
    else newFeed = feedGroup[curGrp].list[curPos+2];
    mvFeed(curGrp,curFeed,newFeed);
  }
}

function mvFeed(curGrp,curFeed,newFeed)
{
  var feedtree = document.getElementById("newsfox.feedTree");
  var curRow = getFeedRow(curGrp,curFeed);
  var newRow = getFeedRow(curGrp,newFeed);
  var curPos;
  var newPos = feedGroup[curGrp].list.length;
  for (var i=0; i<feedGroup[curGrp].list.length; i++)
  {
    if (feedGroup[curGrp].list[i] == curFeed) curPos = i
    else if (feedGroup[curGrp].list[i] == newFeed) newPos = i;
  }
  var up = (newRow > curRow);
  if (curPos == newPos || curPos+1 == newPos) return;
  var curExpand = openidx[curRow];
  if (curExpand) feedtree.view.toggleOpenState(curRow);
  feedGroup[curGrp].list.splice(curPos,1);
  feedGroup[curGrp].list.splice(newPos-up,0,curFeed);
  newRow = getFeedRow(curGrp,newFeed);
  feedidx.splice(curRow,1);
  feedidx.splice(newRow-up,0,curFeed);
  fdgpidx.splice(curRow,1);
  fdgpidx.splice(newRow-up,0,curGrp);
  catgidx.splice(curRow,1);
  catgidx.splice(newRow-up,0,0);
  openidx.splice(curRow,1);
  openidx.splice(newRow-up,0,false);
  if (curExpand) feedtree.view.toggleOpenState(newRow-up);

  saveGroupModel();
  saveIndices();
  refreshModelSelect(newRow-up);
}

function removeHeaderArrows()
{
	var flagObj = document.getElementById("flag");
	var titleObj = document.getElementById("title");
	var readObj = document.getElementById("read");
	var dateObj = document.getElementById("date");
	flagObj.setAttribute("sortDirection", "natural");
	titleObj.setAttribute("sortDirection", "natural");
	readObj.setAttribute("sortDirection", "natural");
	dateObj.setAttribute("sortDirection", "natural");
}

function loadingTooltip(show)
{
	var tooltip = document.getElementById("loadingTooltip");
	if (show)
		tooltip.showPopup();
	else
		tooltip.hidePopup();
}

function setPmeter(value)
{
	var pmeter = document.getElementById("pmeter");
	if (value == 0)
		pmeter.hidden = true;
	else
	{
		pmeter.hidden = false;
		pmeter.setAttribute("value", value + "%");
	}
}
