/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Ron Pruitt <wa84it@gmail.com>.
 * Portions created by the Initial Developer are Copyright (C) 2006-2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function initoverlay(event)
{
	window.removeEventListener('load', initoverlay, false);
  doneButton = CommonFunc.getPrefValue("newsfox.global.doneButton", "bool", false);
  doneAuto = CommonFunc.getPrefValue("newsfox.global.doneAutoSubscribe", "bool", false);
  if (!doneButton) newsfoxdoButton(event);
	if (!doneAuto) addAutoSubscribe();
}

function addAutoSubscribe()
{
  CommonFunc.setPrefValue("newsfox.global.doneAutoSubscribe", "bool", true);
	const nfUri = "chrome://newsfox/content/addurl.xul?%s";
	// following 'appropriate' method doesn't handle chrome://
	// navigator.registerContentHandler("application/vnd.mozilla.maybe.feed", nfUri, "Newsfox");
	var feedUri = new Array();
	for (var i=0; i<=20; i++)
	{
		feedUri[i] = CommonFunc.getPrefValue("browser.contentHandlers.types." + i + ".uri", "str", "");
		if (feedUri[i] == nfUri) return;
	}
	var i=2;
	var done = false;
	while (!done)
		if (feedUri[++i] == "chrome://browser-region/locale/region.properties") done = true;
	CommonFunc.setPrefValue("browser.contentHandlers.types." + i + ".title", "str", "Newsfox");
	CommonFunc.setPrefValue("browser.contentHandlers.types." + i + ".uri", "str", nfUri);
	CommonFunc.setPrefValue("browser.contentHandlers.types." + i + ".type", "str", "application/vnd.mozilla.maybe.feed");
//	CommonFunc.setPrefValue("browser.contentHandlers.auto.application/vnd.mozilla.maybe.feed", "str", nfUri);
//	CommonFunc.setPrefValue("browser.feeds.handlers.webservice", "str", nfUri);
}

function newsfoxdoButton(event)
{
  const nfMENUBAR = "toolbar-menubar";
  const nfNAVBAR = "nav-bar";
  var mbar = document.getElementById(nfMENUBAR);
  var nbar = document.getElementById(nfNAVBAR);
  
	var done = false;
	if (nbar.collapsed == true && mbar && mbar.collapsed == true) done = true;
	if ("currentSet" in nbar && nbar.currentSet.indexOf("newsfox-button") > -1) done = true;
	if (mbar && mbar.currentSet.indexOf("newsfox-button") > -1) done = true;
	if (done)
	{
    CommonFunc.setPrefValue("newsfox.global.doneButton", "bool", true);
    return;
  }

  var newSet = "";

  if (nbar.collapsed == false && "currentSet" in nbar && nbar.currentSet != "__empty") {
    var homeButton = nbar.currentSet.indexOf("home-button");
    if (homeButton > -1)
      newSet = nbar.currentSet.substring(0,homeButton+11) + ",newsfox-button" + nbar.currentSet.substring(homeButton+11,nbar.currentSet.length);
    else {
      var urlbarContainer = nbar.currentSet.indexOf("urlbar-container");
      if (urlbarContainer > -1)
        newSet = nbar.currentSet.substring(0,urlbarContainer) + "newsfox-button," + nbar.currentSet.substring(urlbarContainer,nbar.currentSet.length);
    }
    if (newSet == "")
      newSet = "newsfox-button," + nbar.currentSet;
    nbar.setAttribute("currentset", newSet);
    nbar.currentSet = newSet;
    document.persist(nfNAVBAR, "currentset");
  }
  else if (mbar) {  // put it on menubar
    var homeButton = mbar.currentSet.indexOf("home-button");
    if (homeButton > -1)
      newSet = mbar.currentSet.substring(0,homeButton+11) + ",newsfox-button" + mbar.currentSet.substring(homeButton+11,mbar.currentSet.length);
    else {
      var menubarItems = mbar.currentSet.indexOf("menubar-items");
      if (menubarItems > -1)
        newSet = mbar.currentSet.substring(0,menubarItems+13) + ",newsfox-button" + mbar.currentSet.substring(menubarItems+13,mbar.currentSet.length);
      else { 
        if (mbar.currentSet != "__empty")
          newSet = mbar.currentSet + ",newsfox-button";
      }
    }
    if (newSet != "") {
      mbar.setAttribute("currentset", newSet);
      mbar.currentSet = newSet;
      document.persist(nfMENUBAR, "currentset");
    }
  }
  try {BrowserToolboxCustomizeDone(true);} catch (e) {}
  CommonFunc.setPrefValue("newsfox.global.doneButton", "bool", true);
}

window.addEventListener('load', initoverlay, false);
